/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final Couple<Color> COLOR_NAV_ARROW = Couple.create(new Color(-2136303207, true), new Color(816486809)).map(Color::setImmutable);
    protected static boolean currentlyRenderingPreviousScreen = false;
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    @Nullable
    protected BoxWidget backTrack;

    public NavigatableSimiScreen() {
        class_1041 window = class_310.method_1551().method_22683();
        this.depthPointX = window.method_4486() / 2;
        this.depthPointY = window.method_4502() / 2;
    }

    public void method_25419() {
        ScreenOpener.clearStack();
        super.method_25419();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.backTrack = null;
        List<class_437> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        this.backTrack = (BoxWidget)((AbstractSimiWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(31, this.field_22790 - 31 - 20).withBounds(20, 20)).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)).enableFade(0, 5)).withPadding(2.0f, 2.0f)).fade(1.0f)).withCallback(() -> ScreenOpener.openPreviousScreen(this, null));
        this.method_37063(this.backTrack);
        class_437 previousScreen = screenHistory.get(0);
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen screen = (NavigatableSimiScreen)previousScreen;
            screen.initBackTrackIcon(this.backTrack);
        } else {
            this.backTrack.showing(PonderGuiTextures.ICON_DISABLE);
        }
    }

    protected abstract void initBackTrackIcon(BoxWidget var1);

    protected class_2561 backTrackingComponent() {
        if (ScreenOpener.getBackStepScreen() instanceof NavigatableSimiScreen) {
            return Lang.builder("catnip").translate("gui.step_back", new Object[0]).component();
        }
        return Lang.builder("catnip").translate("gui.exit", new Object[0]).component();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack == null) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        int x = (int)class_3532.method_16439((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
        int maxX = this.backTrack.method_46426() + this.backTrack.method_25368();
        Couple<Color> colors = COLOR_NAV_ARROW;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -300.0f);
        if (x + 30 < this.backTrack.method_46426()) {
            UIRenderHelper.breadcrumbArrow(graphics, x + 30, this.field_22790 - 51, 0, maxX - (x + 30), 20, 5, colors);
        }
        UIRenderHelper.breadcrumbArrow(graphics, x, this.field_22790 - 51, 0, 30, 20, 5, colors);
        UIRenderHelper.breadcrumbArrow(graphics, x - 30, this.field_22790 - 51, 0, 30, 20, 5, colors);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 500.0f);
        if (this.backTrack.method_25367()) {
            class_2561 component = this.backTrackingComponent();
            graphics.method_51439(this.field_22793, component, 41 - this.field_22793.method_27525((class_5348)component) / 2, this.field_22790 - 16, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
            if (class_3532.method_15347((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        poseStack.method_22909();
    }

    public void method_25420(class_332 graphics) {
        if (!NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            super.method_25420(graphics);
        }
    }

    @Override
    protected void renderWindowBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            this.method_25420(graphics);
            return;
        }
        this.method_25420(graphics);
        class_4587 ms = graphics.method_51448();
        class_1041 window = this.field_22787.method_22683();
        float guiScaledWidth = window.method_4486();
        float guiScaledHeight = window.method_4502();
        class_437 lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float tValue = this.transition.getValue(partialTicks);
        float tValueAbsolute = Math.abs(tValue);
        if (lastScreen != null && lastScreen != this && !this.transition.settled()) {
            currentlyRenderingPreviousScreen = true;
            ms.method_22903();
            UIRenderHelper.framebuffer.method_1230(class_310.field_1703);
            UIRenderHelper.framebuffer.method_1235(true);
            lastScreen.method_25394(graphics, 0, 0, partialTicks);
            ms.method_22909();
            ms.method_22903();
            this.field_22787.method_1522().method_1235(true);
            int dpx = (int)(guiScaledWidth / 2.0f);
            int dpy = (int)(guiScaledHeight / 2.0f);
            if (lastScreen instanceof NavigatableSimiScreen) {
                NavigatableSimiScreen navigableScreen = (NavigatableSimiScreen)lastScreen;
                if (tValue > 0.0f) {
                    dpx = navigableScreen.depthPointX;
                    dpy = navigableScreen.depthPointY;
                }
            }
            float scale = 1.0f + 0.2f * tValue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, guiScaledWidth, guiScaledHeight, 0.0f, 1000.0f, 3000.0f);
            class_4587 poseStack2 = new class_4587();
            poseStack2.method_23760().method_23761().set((Matrix4fc)matrix4f);
            poseStack2.method_46416((float)dpx, (float)dpy, 0.0f);
            poseStack2.method_22905(scale, scale, 1.0f);
            poseStack2.method_46416((float)(-dpx), (float)(-dpy), 0.0f);
            UIRenderHelper.drawFramebuffer(poseStack2, 1.0f - tValueAbsolute);
            RenderSystem.disableBlend();
            ms.method_22909();
            currentlyRenderingPreviousScreen = false;
        }
        float scale = tValue > 0.0f ? 1.0f - 0.5f * (1.0f - tValueAbsolute) : 1.0f + 0.5f * (1.0f - tValueAbsolute);
        int dpx = (int)(guiScaledWidth / 2.0f);
        int dpy = (int)(guiScaledHeight / 2.0f);
        ms.method_46416((float)dpx, (float)dpy, 0.0f);
        ms.method_22905(scale, scale, 1.0f);
        ms.method_46416((float)(-dpx), (float)(-dpy), 0.0f);
    }

    @Override
    public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, null);
            return true;
        }
        return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        List<class_437> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, this.field_22787.field_1755);
        int spacing = 20;
        ArrayList<String> names = new ArrayList<String>();
        for (class_437 class_4372 : history) {
            names.add(NavigatableSimiScreen.screenTitle(class_4372));
        }
        int bWidth = 0;
        for (String name : names) {
            bWidth += this.field_22793.method_1727(name) + spacing;
        }
        MutableInt mutableInt = new MutableInt(this.field_22789 - bWidth);
        MutableInt y = new MutableInt(this.field_22790 - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (mutableInt.getValue() < 25) {
            mutableInt.setValue(25);
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 600.0f);
        names.forEach(s -> {
            int sWidth = this.field_22793.method_1727(s);
            UIRenderHelper.breadcrumbArrow(graphics, x.getValue(), y.getValue(), 0, sWidth + spacing, 14, spacing / 2, new Color(-586149872), new Color(0x44101010));
            graphics.method_25303(this.field_22793, s, x.getValue() + 5, y.getValue() + 3, first.getValue() != false ? -1114130 : -2232577);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        poseStack.method_22909();
    }

    public static boolean isCurrentlyRenderingPreviousScreen() {
        return currentlyRenderingPreviousScreen;
    }

    private static String screenTitle(class_437 screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

